unit Unit1;
{test tree structure }

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, Buttons, StdCtrls, shellapi, davArrayBtn;

type
  TForm1 = class(TForm)
    treebox: TPaintBox;
    actionbox: TPaintBox;
    purgeBtn: TSpeedButton;
    initBtn: TSpeedButton;
    msglabel: TLabel;
    marktext: TStaticText;
    xtext: TStaticText;
    ytext: TStaticText;
    parenttext: TStaticText;
    childtext: TStaticText;
    nexttext: TStaticText;
    previoustext: TStaticText;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    freeText: TStaticText;
    Label1: TLabel;
    downbtn: TSpeedButton;
    SpeedButton1: TSpeedButton;
    Label10: TLabel;
    startBtn: TSpeedButton;
    Image1: TImage;
    menuBtn: TDavArrayBtn;
    undoBtn: TSpeedButton;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure purgeBtnClick(Sender: TObject);
    procedure treeboxPaint(Sender: TObject);
    procedure treeboxMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure treeboxMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure initBtnClick(Sender: TObject);
    procedure actionboxPaint(Sender: TObject);
    procedure downbtnClick(Sender: TObject);
    procedure SpeedButton1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SpeedButton1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure startBtnClick(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure menuBtnBtnChange(sender: TObject; BtnNr: Byte;
      status: TBtnStatus; button: TMouseButton);
    procedure menuBtnBtnPaint(sender: TObject; BtnNr: Byte;
      status: TBtnStatus);
    procedure FormDestroy(Sender: TObject);
    procedure treeboxMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure undoBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses tree_unit;

{$R *.dfm}

type TMenuBtn = (mbPlaceA,mbPlaceB,mbPlaceChildA,mbPlaceChildB,mbReplace,
                 mbMark,mbDelete,mbOff);

const mainBtntext : array[0..6] of string =
           ('place-A','place-B','placeChild-A','placeChild-B','replace',
            'mark','delete');

var marker   : dword;     //marked element <> 0
    selected : byte = 0;
    scancode : TLinktype;
    menubutton : Tmenubtn = mbOff;
    bm : Tbitmap;
//-- move info
    mcc     : byte = 0;    //mouse move control count [0,1,2]
    mvelmnt : dword = 0;
    mvrect  : Trect;       //rectangle of moving element
    mvoffX  : word;        //x offset
    mvoffY  : word;        //y offset
    mvdest  : byte;        //destination element

//--- low level support ---

procedure boxEdges(box : Tpaintbox);
//pait edges around a paintbox
var x1,y1,x2,y2 : word;
begin
 with box do
  begin
   x1 := left-1;
   y1 := top-1;
   x2 := left + width;
   y2 := top + height;
  end;
 with getParentform(box).canvas do
  begin
   pen.width := 1;
   pen.color := $c0c0c0;
   moveto(x1,y1);
   lineto(x1,y2);
   lineto(x2,y2);
   lineto(x2,y1);
   lineto(x1,y1);
  end;
end;

procedure clearbm;
var r : Trect;
begin
 with bm do with canvas do
  begin
   brush.Style := bsSolid;
   brush.Color := $f0ffff;
   r := rect(0,0,width,height);
   fillrect(r);
  end;
end;

procedure clearBox(box : Tpaintbox);
begin
 with box do with canvas do
  begin
   brush.Color := $f0ffff;
   brush.Style := bssolid;
   fillrect(rect(0,0,width,height));
   pen.Color := $0;
   font.Name := 'arial';
   font.Height := 18;
   font.Style := [];
  end;
end;

procedure updatePos(x,y : integer);
//update moverect during element move
begin
 with mvrect do
  begin
   left := x - mvoffX;
   top  := y - mvoffY;
   right := left + 40;
   bottom := top + 20;
  end;
end;

function getElementRect(elnr : dword) : Trect;
begin
 with element[elnr] do
  begin
   result.Left := (x-1)*65+5;
   result.Right := result.Left + 40;
   result.top := (y-1)*30 + 5;
   result.Bottom := result.Top + 20;
  end;
end;

procedure copyEL(elmnt : dword);
//copy element from bm to treebox
var r : Trect;
begin
 r := getelementrect(elmnt);
 form1.treebox.Canvas.copyrect(r,bm.Canvas,r);
end;

procedure restoremove;
//erase area of moving element in treebox
begin
 form1.treebox.canvas.copyrect(mvrect,bm.Canvas,mvrect);
end;

function XY2element(x1,y1 : integer) : byte;
//mouse (x,y) to element#, 0 : none
var px,py : word;
    hit   : boolean;
    i     : byte;
begin
 for i := 1 to maxelement do
  with element[i] do
   if (x > 0) and (y > 0) then
    begin
     px := (x-1)*65;
     py := (y-1)*30;
     hit := (x1 > px + 5) and (x1 < px + 45) and
            (y1 > py + 5) and (y1 < py + 25);
     if hit then
      begin
       result := i;
       exit;
      end;
    end;
 result := 0;
end;

procedure paintelement(canv : TCanvas; x,y : integer; nr : dword);
//paint element at position (x,y) of canv
//do not paint connections
var r : Trect;
    s : string;
    w : word;
begin
 with canv do
  begin
   r.Left := x;
   r.Right := x + 40;
   r.top := y;
   r.bottom := y + 20;
   pen.Color := $000000;
   if element[nr].marked then brush.Color := $00f0f0
    else brush.Color := $f0ffff;
   brush.Style := bsSolid;
   fillrect(r);
   moveto(r.left,r.top);
   lineto(r.Left,r.Bottom-1);
   lineto(r.Right-1,r.Bottom-1);
   lineto(r.Right-1,r.top);
   lineto(r.Left,r.Top);
   s := inttostr(nr);
   w := textwidth(s);
   brush.Style := bsClear;
   font.Height := 18;
   font.Color := $000000;
   textout(r.Left + 35-w,r.Top + 1,s);
  end;//canv
end;

procedure paintElementNr(nr : dword);
//paint element[nr] on bm
//includes connecting lines
var r,t : Trect;
    prev,par : dword;
begin
 with bm.canvas do
  begin
   r := getElementRect(nr);
   paintelement(bm.Canvas,r.left,r.top,nr);
   prev := element[nr].previous;
   if prev > 0 then
    begin
     t := getElementRect(prev);
     moveto(t.left + 20,t.Bottom);
     lineto(r.Left + 20,r.Top);
    end;
   par := element[nr].parent;
   if (prev = 0) and (par > 0) then
    begin
     t := getelementRect(par);
     moveto(t.Right, t.Top+10);
     lineto(r.Left,r.top+10);
    end;
  end;//with form1.treebox
end;

procedure paintFreeElements;
//paint first 23 free elements
var i : dword;
    n : byte;
begin
 n := 1;
 for i := 1 to maxelement do
  begin
   with element[i] do
    if eltype = elfree then
     if n <= 23 then
      begin
       x := 8;
       y := n;
       paintElementNr(i);
       inc(n);
      end
      else begin
            x := 0;
            y := 0;
            end;
  end; 
end;

procedure paintTree;
//calculate element x,y & paint
var elmnt : dword;
    mcode : TLinktype;             //result movecode of DownElement function
    posX,posY : byte;
    pnt : boolean;               //paint flag
begin
 clearbm;
 elmnt := 1;
 posX := 1;
 posY := 1;
 mcode := ltChild;
 pnt := true;
 repeat
  if pnt then paintElementNr(elmnt);
  mcode := ScanElement(elmnt,mcode);
  case mcode of
   ltParent : dec(posX);
   ltChild  : inc(posX);
   ltNext   : inc(posY);
  end;
  pnt := (mcode = ltChild) or (mcode = ltNext);
  if pnt then
   with element[elmnt] do
    begin
     x := posX;
     y := posY;
    end;
 until mcode = ltNone;
 paintFreeElements;
 form1.treebox.Canvas.Draw(0,0,bm);
end;

procedure showElementInfo;
begin
 with form1 do with element[marker] do
  begin
   marktext.Caption := inttostr(marker);
   xtext.Caption := inttostr(x);
   ytext.Caption := inttostr(y);
   parenttext.Caption := inttostr(parent);
   childtext.Caption := inttostr(child);
   previoustext.Caption := inttostr(previous);
   nexttext.Caption := inttostr(next);
   freeText.caption := inttostr(freeElementcount);
  end;//with form1
end;

procedure unmarkElement;
begin
 if marker > 0 then
  begin
   element[marker].marked := false;
   paintElementNr(marker);
   copyEL(marker);
   marker := 0;
  end;
end;

procedure markelement(elmnt : dword);
//mark element, update marker[ ] , paint
begin
 element[marker].marked := false;
 paintelementNr(marker);
 copyEL(marker);
 marker := elmnt;
 element[elmnt].marked := true;
 paintelementNr(marker);
 copyEL(marker);
 showElementInfo;
end;

function test1(el : dword) : boolean;
//check el <> 1
begin
 result := el <> 1;
 with form1.msglabel do
  if result=false then caption := 'not possible for element 1'
   else caption := '';
end;

function testfree(el : dword) : boolean;
//test if el is free
begin
 result := element[el].eltype = elFree;
 with form1.msglabel do
  if result = false then caption := 'not free element'
   else caption := '';
end;   

procedure init;
//initialize elements, undo-stack, marker
//install element 1
begin
 initTreedata;
 with element[1] do
  begin
   eltype := elActive;
   marked := true;
   x := 1;
   y := 1;
  end;
 dec(freeElementcount); 
 marker := 1;
 scancode := ltNone;
end;

procedure showActions;
var i : word;
    y : word;
    s1,s2,s3 : string;
begin
 with form1 do
  begin
   clearbox(actionbox);
   with actionbox.Canvas do
    begin
     font.name := 'arial';
     font.Height := 18;
     font.Color := $0;
     font.Style := [];
     i := 1;
     while i <= lastaction do
      begin
       y := (i-1) * 20;
       with undolist[i] do
        begin
         case action of
          eaPlaceA       : s1 := 'insA';
          eaPlaceB       : s1 := 'insB';
          eaPlaceChildA  : s1 := 'insCA';
          eaPlaceChildB  : s1 := 'insCB';
          eaReplace : s1 := 'repl';
          eaDelete  : s1 := 'del';
         end; //case
         textout(5,y,s1);
         s1 := inttostr(elmnt);
         s2 := '(';
         case linktype of
          ltparent   : s2 := s2 + 'Pa';
          ltnext     : s2 := s2 + 'Ne';
          ltPrevious : s2 := s2 + 'Pr';
         end;
         s2 := s2 + inttostr(linkEL)+')';
         if bwlink then s3 := 'L' else s3 := '';
        end;//with
       textout(80  - textwidth(s1),y,s1);
       textout(160 - textwidth(s2),y,s2);
       textout(180 - textwidth(s3),y,s3);
       inc(i);
      end;//while
    end;//with actionbox
  end;//with form1
end;

//--- events ---

procedure TForm1.FormCreate(Sender: TObject);
begin
 init;
 bm := Tbitmap.Create;
 with bm do
  begin
   width := treebox.Width;
   height := treebox.Height;
   pixelformat := pf32bit;
   with canvas do
    begin
     font.Name := 'arial';
     font.Height := 16;
    end;
  end; 
 with menuBtn do with canvas.font do
  begin
   name := 'arial';
   height := 20;
   BtnDown(0);
   menuButton := TmenuBtn(0);
  end;
 showElementInfo;
 scancode := ltChild;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
 bm.Free;
 bm := nil;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
 boxedges(treebox);
 boxedges(actionbox);
end;

procedure TForm1.undoBtnClick(Sender: TObject);
begin
 msglabel.Caption := '';
 if lastAction > 0 then undoElement;
 painttree;
 showactions;
 showelementInfo;
end;

procedure TForm1.purgeBtnClick(Sender: TObject);
begin
 msglabel.Caption := '';
 purgeUndoStack;
 showActions;
 showElementInfo;
end;

procedure TForm1.treeboxPaint(Sender: TObject);
begin
 paintTree;
 showActions;
end;

procedure TForm1.treeboxMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var m : byte;
begin
 case mcc of
  0 : begin
       m := xy2element(x,y);
       if (m <> selected) then
        begin
         if m > 0 then
          begin
           treebox.Cursor := crhandpoint;
           selected := m;
          end
          else
           begin
            treebox.Cursor := crArrow;
            selected := 0;
           end; 
         end;
      end;
  1 : begin
       paintelement(form1.treebox.Canvas,x-mvoffX,y-mvoffY,mvelmnt);
       updatePos(x,y);
       mcc := 2;
      end;
  2  : begin
        restoremove;
        paintelement(form1.treebox.Canvas,x-mvoffX,y-mvoffY,mvelmnt);
        updatePos(x,y);
       end;
 end;//case
end;

procedure TForm1.treeboxMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var r : Trect;
begin
 msglabel.Caption := '';
 case menubutton of
  mbPlaceA,
  mbPlaceB,
  mbPlaceChildA,
  mbPlaceChildB  : if test1(selected) then
                   case mcc of                  //prepare for move
                    0 : begin
                         mvelmnt := selected;
                         r := getElementrect(selected);
                         mvrect := r;
                         mvoffX := x - r.Left;
                         mvoffY := y - r.Top;
                         mcc := 1;
                        end;
                    1,2 : ;
                   end;//case
  mbreplace      : if test1(selected) then
                   case mcc of
                    0 : begin
                         mvelmnt := selected;
                         if testfree(mvelmnt) then
                          begin
                           r := getElementrect(selected);
                           mvrect := r;
                           mvoffX := x - r.Left;
                           mvoffY := y - r.Top;
                           mcc := 1;
                          end;
                        end;
                     1,2 : ;
                   end;
  mbDelete       : if (element[selected].eltype = elActive) and
                    test1(selected) then
                     begin
                      deleteEL(selected);
                      element[selected].x := 0;
                      element[selected].y := 0;//set to deleted
                      painttree;
                      showactions;
                     end;
  mbMark         : if (selected > 0) and element[selected].marked then
                    unmarkelement
                    else begin
                          markelement(selected);
                          scancode := ltChild;
                         end;
 end;//case
end;

procedure TForm1.treeboxMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 if mcc = 2 then
  begin
   msglabel.Caption := '';
   mvdest := xy2element(x-mvoffX,y-mvoffY);
   if (mvdest > 0) and (element[mvdest].eltype = elActive) and
      (mvdest <> mvelmnt) then
    begin
     element[mvelmnt].eltype := elActive;
     case menubutton of
      mbPlaceA      : placeELA(mvdest,mvelmnt);
      mbPlaceB      : if test1(mvdest) then placeELB(mvdest,mvelmnt) ;
      mbPlaceChildA : placeChildA(mvdest,mvelmnt);
      mbPlaceChildB : placeChildB(mvdest,mvelmnt);
      mbReplace     : if test1(mvdest) then
                       begin
                        replaceEL(mvdest,mvelmnt);
                        element[mvdest].x := 0;//set to deleted
                        element[mvdest].y := 0;
                       end;
     end;
     showactions;
    end;//if
  end; //if mcc
 mcc := 0;
 selected := 0;
 treebox.Cursor := crArrow;
 paintTree;
 showElementInfo;
end;

procedure TForm1.initBtnClick(Sender: TObject);
begin
 init;
 paintTree;
 clearBox(form1.actionBox);
 showElementInfo;
end;

procedure TForm1.actionboxPaint(Sender: TObject);
begin
 showActions;
end;

procedure TForm1.downbtnClick(Sender: TObject);
var m : dword;
begin
 if marker = 0 then
  begin
   msglabel.Caption := 'no element marked';
   exit;
  end 
  else msglabel.Caption := '';
 m := marker;
 scancode := ScanElement(m,scancode);
 if scancode <> ltNone then markelement(m);
 showelementInfo;
end;

procedure TForm1.SpeedButton1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
//elements overview
var i,col,row : byte;
    x1,y1,x2,y2 : word;
    color : dword;
begin
 clearBox(treebox);
 treebox.Canvas.brush.style := bsClear;
 color := $0;
 for i := 1 to maxelement do
  begin
   col := (i-1) mod 5;
   row := (i-1) div 5;
   x1 := col * 90 + 5;
   x2 := x1 + 80;
   y1 := row * 70 + 5;
   y2 := y1 + 60;
   with treebox.Canvas do
    begin
     case getELstatus(i) of
      esFree : color := $00c000;
      esDeleted : color := $0000ff;
      esActive : color := $000000;
     end;
     pen.color := color;
     moveto(x1,y1);
     lineto(x1,y2);
     lineto(x2,y2);
     lineto(x2,y1);
     lineto(x1,y1);
     font.Height := 22;
     font.color := color;
     textout(x1+3,y1+3,inttostr(i));
     font.Height := 15;
     x1 := x1 + 30;
     with element[i] do
      begin
       textout(x1,y1,'par');
       textout(x1,y1+15,'chd');
       textout(x1,y1+30,'nxt');
       textout(x1,y1+45,'prv');
       x1 := x1 + 25;
       textout(x1,y1,inttostr(parent));
       textout(x1,y1+15,inttostr(child));
       textout(x1,y1+30,inttostr(next));
       textout(x1,y1+45,inttostr(previous));
      end;
    end;//with treebox
  end;//for i
end;

procedure TForm1.SpeedButton1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 form1.treebox.Canvas.draw(0,0,bm);
end;

procedure TForm1.startBtnClick(Sender: TObject);
begin
 if startBtn.Down then startLinking else stopLinking;
end;

procedure TForm1.Image1Click(Sender: TObject);
//davdata website
begin
 ShellExecute(0,'open','http://www.davdata.nl', nil, nil, SW_SHOWNORMAL);
end;

procedure TForm1.menuBtnBtnChange(sender: TObject; BtnNr: Byte;
  status: TBtnStatus; button: TMouseButton);
begin
 menubutton := mbOff;
 if status = stDown then menubutton := TmenuBtn(BtnNr);
end;

procedure TForm1.menuBtnBtnPaint(sender: TObject; BtnNr: Byte;
  status: TBtnStatus);
var r : Trect;
    s : string;
    x,y : word;
begin
 with menubtn do with canvas do
  begin
   r := getBtnRect(BtnNr);
   s := mainBtnText[BtnNr];
   if status = stFlat then font.Style := [] else font.Style := [fsBold];
   x := r.Left + (BtnWidth - textwidth(s)) div 2;
   y := r.Top + (Btnheight - textheight(s)) div 2;
   textout(x,y,s);
  end;
end;

end.
