unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    msglabel: TLabel;
    Label2: TLabel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    playerstartBtn: TSpeedButton;
    compstartBtn: TSpeedButton;
    newgameBtn: TSpeedButton;
    randomBox: TCheckBox;
    startBtn: TSpeedButton;
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure startBtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure newgameBtnClick(Sender: TObject);
    procedure PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
  TgameState = (gsIdle,gsSetUp,gsPlayer,gsComp);
  TgameMessage = (gmInit,gmNew,gmStart,gmPlayerMoved,gmCompMoved);

procedure GameControl(gm : TGameMessage);forward;

var
  Form1: TForm1;

implementation

uses clock_unit;

{$R *.dfm}

var GPos : array[1..2,1..5] of byte;//1..2:computer,player;1..5: row
                                    //value:column
    Game : array[1..5,1..12] of byte;//0:empty; 1:computer; 2:player                                
    rowcount : byte = 2;
    Gmap : Tbitmap;
    CHmap : array[0..2] of Tbitmap;
    gamestate : TGameState = gsIdle;
    movebusy : boolean;

procedure delay(t : longword); //delay t millisecs
begin
 startclock;  //--> clock_unit
 repeat
  application.processmessages;
 until getCPUtime >= t;  //--> clock_unit
end;

function GetRect(r,c : Byte) : Trect;
begin
 dec(r);
 dec(c);
 with result do
  begin
   left := c*40;
   top := r*40;
   right := left+40;
   bottom := top+40;
  end;
end;

procedure registerMove(p,row,column : byte);
begin
 Game[row,column] := p;
 Gpos[p,row] := column;
end;

procedure clearmap(mp : Tbitmap; color : longword);
//clear any bitmap
begin
 with mp do with canvas do
  begin
   brush.style := bsSolid;
   brush.Color := color;
   fillrect(rect(0,0,width,height));
  end;
end;

procedure clearField(x,y : word);
var sx : word;
     i : byte;
begin
 with Gmap.Canvas do
  begin
   draw(x,y,CHmap[0]);
   pen.width := 1;
   pen.color := $0;
   for i := 1 to 11 do       //restore vertical field line
    begin
     sx := i*40;
     if (sx >= x) and (sx <= x+40) then
     begin
      moveto(sx,0);
      lineto(sx,rowcount*40);
     end;
    end;
  end;
end;

procedure paintGmapGrid;
var i : word;
begin
 clearmap(Gmap,$f0ffff);
 with Gmap do with canvas do
  begin
   pen.Color := $0;
   i := 40;
   pen.Width := 1;
   while i < height do
    begin
     moveto(0,i);
     lineto(width,i);
     inc(i,40);
    end;
   i := 40;
   while i < width do
    begin
     moveto(i,0);
     lineto(i,height);
     inc(i,40);
    end;
  end;
end;

procedure clearPos(row,col : byte);
//clear Gpos, Game, update paintbox
var r : Trect;
    p : byte;
begin
 Gmap.Canvas.draw((col-1)*40,(row-1)*40,CHmap[0]);
 r := GetRect(row,col);
 form1.paintbox1.canvas.copyrect(r,Gmap.canvas,r);
 p := Game[row,col];
 Gpos[p,row] := 0;
 Game[row,col] := 0;
end;

procedure move(p,row,NewColumn : byte);
//move p of row to NewColumn
var r : Trect;
    oldColumn : byte;
    OK : boolean;
begin
 oldColumn := Gpos[p,row];
 OK := false;
 case p of
  1 : OK := NewColumn < GPos[2,row];
  2 : OK := NewColumn > GPos[1,row];
 end;
 if OK then
  begin
   clearPos(row,oldColumn);
   r := GetRect(row,NewColumn);
   Gmap.canvas.draw(r.left,r.top,ChMap[p]);
   form1.paintbox1.canvas.copyrect(r,Gmap.canvas,r);
   registerMove(p,row,NewColumn);
  end;
end;

procedure moveto(p,row,column : byte);
//move piece p of row to column
var x,destx,y : word;
    dx : shortInt;
    r : Trect;
begin
 movebusy := true;
 if Gpos[p,row]-column > 0 then dx := -1 else dx := 1;
 destX := (column-1)*40;
 x := (Gpos[p,row]-1)*40;
 y := (row-1)*40;
 while destX <> x do
  begin
   clearField(x,y);
   x := x + dx;
   Gmap.Canvas.Draw(x,y,CHmap[p]);
   r := rect(x-1,y,x+41,y+40);
   form1.PaintBox1.Canvas.CopyRect(r,Gmap.Canvas,r);
   delay(3);
  end;
 Gpos[p,row] := 0;
 Game[row,column] := 0;
 Gpos[p,row] := column;
 Game[row,column] := p;
end;

procedure clearGameData;
var i,j : byte;
begin
 for i := 1 to 2 do   //1:computer; 2:player
  for j := 1 to 5 do  //rows 1..5
    Gpos[i,j] := 0;   //empty
 for j := 1 to 5 do   //row
  for i := 1 to 12 do //column
   Game[j,i] := 0;
end;

procedure paintGame;
//paint Gmap, copy to paintbox
var i,j : word;
    a : byte;
begin
 paintGmapGrid;
 for i := 1 to 12 do
  for j := 1 to 5 do
   begin
    a := Game[j,i];
    Gmap.Canvas.Draw((i-1)*40,(j-1)*40,ChMap[a]);
   end;
 form1.PaintBox1.Canvas.Draw(0,0,Gmap);
end;

procedure makeNewGame;
var i,rdO,rdX : byte;
begin
 clearGameData;
 randomize;
 rdO := 0;
 rdX := 0;
 for i := 1 to rowcount do
  begin
   if form1.randombox.checked then
    begin
     rdO := random(6);
     rdX := random(6);
    end;
   registerMove(1,i,1+rdO);
   registerMove(2,i,12-rdX);
  end;
 paintGame;
end;

procedure computerMove;
var d : array[1..5] of byte;
    dd : array[1..5] of byte;
    col,row,i,newColumn,sum : byte;
    OK : boolean;
begin
 row := 0;
 newColumn := 0;
 for i := 1 to rowcount do d[i] := Gpos[2,i] - Gpos[1,i] - 1;
 sum := 0;
 for i := 1 to rowcount do sum := sum xor d[i];
 if sum = 0 then
  begin
   col := 0;
   row := 0;
   for i := 1 to rowcount do
    if Gpos[2,i] > col then
     begin
      row := i;
      col  := Gpos[2,i];
     end;
   NewColumn := 1 + random(col-2);
   if NewColumn = Gpos[1,row] then inc(newColumn);
  end
  else begin
        for i := 1 to rowcount do dd[i] := d[i] xor sum;
        i := 0;
        repeat
         inc(i);
         OK := dd[i] < d[i];
        until OK or (i = rowcount);
        if OK then
         begin
          newColumn := Gpos[2,i] - dd[i] - 1;
          row := i;
         end;
       end;
 moveBusy := true;      
 delay(500);//msecs
 moveto(1,row,NewColumn);
 gamecontrol(gmCompMoved);
end;

function winning : boolean;
var i,p,col : byte;    //I : row
begin
 if gamestate = gsComp then
  begin
   p := 1;
   col := 11;
  end
  else begin
        p := 2;
        col := 1;
       end;
 result := true;
 i := 0;
 repeat
  inc(i);
  result := result and (Gpos[1,i]=col) and (Gpos[2,i]=col+1);
 until i = rowcount;
 if result then
  begin
   if p=1 then form1.msglabel.Caption := 'Computer wins.'
    else form1.msglabel.Caption := 'You have won !';
   gamestate := gsIdle;
  end;
end;

procedure setdimensions;
//clear old game
//set width,height of paintbox1
var r : Trect;
begin
 with form1.paintbox1 do         //remove old paintbox
  r := rect(Left-2,top-2,left+width+2,top+height+2);
 with form1.Canvas do
  begin
   brush.Color := form1.Color;
   brush.Style := bsSolid;
   fillrect(r);
  end;
 with form1.PaintBox1 do
  begin
   width := 480;              //12 fields * 40
   height := rowcount*40;
   Gmap.Width := width;
   Gmap.Height:= height;
   paintGmapGrid;
  end;
end;

procedure createGmap;
begin
 Gmap := Tbitmap.Create;
 with Gmap do
  begin
   width := 480;
   height := rowcount*40;
   pixelformat := pf15bit;
   clearMap(Gmap,$f0ffff);
   paintGmapGrid;
  end;
end;

procedure createCharMaps;
//'O','X' maps
const Ch : array[0..2] of char = (' ','O','X');
      ChCol : array[0..2] of longword = ($f0ffff,$0000ff,$ff0000);
var i : byte;
begin
 for i := 0 to 2 do
  begin
   CHmap[i] := Tbitmap.Create;
   with  CHmap[i] do
    begin
     width := 40;
     height := 40;
     pixelformat := pf15bit;
     transparent := true;
     transparentcolor := $ffffff;
     with canvas do
      begin
       brush.Color := $ffffff;
       fillrect(rect(0,0,40,40));
       brush.color := $f0ffff;
       fillrect(rect(2,2,38,38));
       font.Name := 'arial';
       font.Color := ChCol[i];
       font.Height:= 36;
       font.style := [fsBold];
       brush.Style := bsClear;
       textout(10,2,Ch[i]);
      end;
    end;
  end;
end;

procedure paintedges;
//paint edges around painbox1
var x1,y1,x2,y2 : word;
    i : byte;
begin
 with form1 do
  begin
   with paintbox1 do
    begin
     x1 := Left-2;
     y1 := top-2;
     x2 := Left+Width+1;
     y2 := top+height+1;
    end;
   with canvas do
    begin
     pen.Width := 1;
     pen.Color := $0;
     for i := 0 to 1 do
      begin
       moveto(x1+i,y1+i);
       lineto(x1+i,y2-i);
       lineto(x2-i,y2-i);
       lineto(x2-i,y1+i);
       lineto(x1+i,y1+i);
      end;
    end;
  end;
end;

procedure EnableResize(a : Boolean);
begin
 with form1 do
  begin
   speedbutton1.Enabled := a;
   speedbutton2.Enabled := a;
   speedbutton3.Enabled := a;
   speedbutton4.Enabled := a;
  end;
end;

procedure GameControl(gm : TGameMessage);
//game control
const msg1 = 'SetUp. Change game or <start> ';
      msg2 = 'Select < newgame>';
      msg3 = 'Computer moving';
      msg4 = 'Your move...';
      msg5 = 'Welcome at the Nim puzzles';
begin
 case gm of
  gmInit       : begin
                  createCharMaps;
                  createGmap;
                  gamestate := gsIdle;
                  form1.msglabel.caption := msg5;
                 end;
  gmNew        : begin
                  EnableResize(true);
                  makeNewGame;
                  gameState := gsSetUp;
                  moveBusy:= false;
                 end;
  gmStart      : if gameState = gsSetUp then
                  begin
                   enableResize(false);
                   if form1.compstartBtn.down then
                    begin
                     gameState := gsComp;
                     if winning then exit;
                     form1.msglabel.Caption := msg3;
                     computerMove;
                    end
                    else begin
                          gamestate := gsPlayer;
                          if winning then exit;
                          form1.msglabel.Caption := msg4;
                         end;
                  end else form1.msglabel.Caption := msg2;

  gmPlayerMoved : if winning then exit
                   else begin
                         moveBusy := false;
                         form1.msglabel.Caption := msg3;
                         gameState := gsComp;
                         computerMove;
                        end;
  gmCompMoved   : if winning then exit
                   else begin
                         moveBusy := false;
                         form1.msglabel.Caption := msg4;
                         gameState := gsPlayer;
                        end;
 end;//case
end;

//-- events --

procedure TForm1.SpeedButton1Click(Sender: TObject);
//rowcount 
begin
 rowcount := TSpeedbutton(sender).tag;
 setdimensions;
 paintedges;
 paintGmapGrid;
 gamestate := gsIdle;
 msglabel.Caption := 'Select new game';
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
 paintedges;
end;

procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
 paintbox1.canvas.draw(0,0,Gmap);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 gamecontrol(gmInit);
end;

procedure TForm1.FormDestroy(Sender: TObject);
var i : byte;
begin
 Gmap.Free;
 for i := 0 to 2 do ChMap[i].Free;
end;

procedure TForm1.PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var row,col : byte;
begin
 if movebusy then exit;
//
 row := (y div 40) + 1;
 col := (x div 40) + 1;
 if gamestate = gsSetUp then
  begin
   if button = mbLeft then move(2,row,col);
   if button = mbRight then move(1,row,col);
  end;
 if gamestate = gsPlayer then
  if col > Gpos[1,row] then
   begin
    moveBusy := true;
    moveto(2,row,col);
    GameControl(gmPlayerMoved);
   end; 
end;

procedure TForm1.newgameBtnClick(Sender: TObject);
begin
 gamecontrol(gmNew);
end;

procedure TForm1.startBtnClick(Sender: TObject);
begin
 GameControl(gmStart);
end;

end.
