unit Unit1;

{  parabola

   1.   Y = X^2
   2.   y = -(X-2)^2

   find points A on 1. and B on 2. such that
   AB is minimal

   method used is successive approximation
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Acoords: TLabel;
    Bcoords: TLabel;
    ABlabel: TLabel;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

type TDistance = record
                  x1 : single;//A
                  y1 : single;
                  x2 : single;//B
                  y2 : single;
                  D  : single;//distance AB
                end;

procedure TForm1.Button1Click(Sender: TObject);
const fs ='##0.0##';
      dx = 1e-6;
var DD : array[0..8] of TDistance;
    i,match : byte;
    s  : string;
    DDD,step : single;
begin
 decimalseparator := '.';
 with DD[0] do   //preset AB
  begin
   x1 := 1;
   x2 := 1;
   y1 := sqr(x1);
   y2 := -sqr(x2-2);
   D := sqr(x2-x1) + sqr(y2-y1);
  end; 
 step := 0.1;
 repeat
  for i := 1 to 8 do
   begin
    case i mod 3 of
     0 : DD[i].x1 := DD[0].x1;
     1 : DD[i].x1 := DD[0].x1-step;
     2 : DD[i].x1 := DD[0].x1+step;
    end;
    case i div 3 of
     0 : DD[i].x2 := DD[0].x2;
     1 : DD[i].x2 := DD[0].x2-step;
     2 : DD[i].x2 := DD[0].x2+step;
    end;
   with DD[i] do
    begin
     y1 := sqr(x1);
     y2 := -sqr(x2-2);
     D := sqr(x1-x2) + sqr(y1-y2);
    end;
   end;//for i
  match := 0;
  DDD := DD[0].D;
  for i := 1 to 8 do
   if DD[i].D < DDD then
    begin
     DDD := DD[i].D;
     match := i;
    end;
  if match > 0 then DD[0] := DD[match]
   else step := step/2;
 until step < 1e-6;
//
 with DD[0] do
  begin
   s := '('+formatfloat(fs,x1);
   s := s + ' , '+formatfloat(fs,y1)+')';
   Acoords.Caption := s;
   s := '('+formatfloat(fs,x2);
   s := s + ' , '+formatfloat(fs,y2)+')';
   Bcoords.Caption := s;
   ABlabel.Caption := formatfloat(fs,sqrt(D));
  end;
end;

end.
