unit Unit1;

{ version 1.0

  generate test data for polygon unit
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, Grids;

const boxwidth = 800;  //dimensions of paintbox
      boxheight = 600; //..

type
  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    msgtext: TStaticText;
    clearbtn: TBitBtn;
    Label2: TLabel;
    drawbtn: TSpeedButton;
    modifyBtn: TSpeedButton;
    Label6: TLabel;
    xposlabel: TLabel;
    Label8: TLabel;
    yposlabel: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    pointsgrid: TStringGrid;
    crsr1: TImage;
    crsr2: TImage;
    undoBtn: TBitBtn;
    areaBtn: TBitBtn;
    repaintBtn: TBitBtn;
    autoprocbox: TCheckBox;
    OpenDialog1: TOpenDialog;
    fillcheckbox: TCheckBox;
    trianglecheckbox: TCheckBox;
    procedure FormPaint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure clearbtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure PaintBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure xleftKeyPress(Sender: TObject; var Key: Char);
    procedure pointsgridKeyPress(Sender: TObject; var Key: Char);
    procedure PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PaintBox1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure drawbtnClick(Sender: TObject);
    procedure modifyBtnClick(Sender: TObject);
    procedure undoBtnClick(Sender: TObject);
    procedure areaBtnClick(Sender: TObject);
    procedure repaintBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

procedure pbedge(pb : TPaintbox; w : byte);

implementation

{$R *.dfm}

uses poly_unit;

const rnd05 = 0.5;        //rounding
      fillcolor = $e0f0f0;
      pencolor = $000000;

type TmouseAction = (maDown,maMove,maUp);
     TmainBtn = (mbDraw,mbModify);

var map1 : Tbitmap;
    map2 : Tbitmap;
    points : array[1..maxpolypoint] of TPoint;      //coordinates
    pcount : word = 0;                              //coord. count

    map1rect : Trect;    //modified area of map1
    map1full : boolean;  //map1 rectangle valid
    map2rect : Trect;
    map2full : boolean;
    paintRect: Trect;

    mouseX   : longInt;   //x mouse coordinate
    mouseY   : longInt;   //y ...
    oldX     : longInt;
    oldY     : longInt;
    mouseAction : Tmouseaction;  //move, down, up
    mcount   : byte = 0;  //drawing control
    selpoint : word;      //modify on this point

    mainbutton : TMainbtn;

    xbias : double = 0;
    ybias : double = 0;
    xyscale : double = 1;
    xyresolution : double = 0;

//---drawing support---

function packrect(x1,y1,x2,y2 : longint): Trect;
//convert coordinates to rectangle
begin
 with result do
  begin
   if x2 > x1 then
    begin
     left := x1-1;
     right := x2 + 1;
    end
    else begin
          left := x2-1;
          right := x1+1;
         end;
   if y1 < y2 then
    begin
     top := y1-1;
     bottom := y2 + 1;
    end
    else begin
          top := y2-1;
          bottom := y1+1;
         end;
  end;//with
end;

function unirect(const r1,r2 : Trect) : Trect;
//unite rectangles r1,r2
begin
 with result do
  begin
   if r1.Left < r2.Left then left := r1.left else left := r2.Left;
   if r1.Right > r2.Right then right := r1.Right else right := r2.Right;
   if r1.Top < r2.Top then top := r1.top else top := r2.Top;
   if r1.Bottom > r2.Bottom then bottom := r1.Bottom else bottom := r2.Bottom;
  end;//with
end;

procedure update1(const r : Trect);
//update map1rect
begin
 if map1full then map1rect := unirect(r, map1rect) else map1rect := r;
 map1full := true;
end;

procedure update2(const r : Trect);
//update map2rect
begin
 if map2full then map1rect := unirect(r, map2rect) else map2rect := r;
 map2full := true;
end;

procedure update12(const r : Trect);
//update maps1,2 on draw
begin
 update1(r);
 update2(r);
end;

procedure copymap12;
//copy rectangle from map1 to map2
begin
 if map1full then
  begin
   map2.Canvas.CopyRect(map1rect,map1.Canvas,map1rect);
   map2rect := unirect(map1rect,map2rect);
   map2full := true;
   map1full := false;
  end;
end;

procedure copymap2box;
//copy rectangle from map2 to paintbox1
begin
 if map2full then
  begin
   form1.PaintBox1.Canvas.CopyRect(map2rect,map2.Canvas,map2rect);
   map2full := false;
  end;
end;

function closecheck : boolean;
//return true if closed polygon
begin
 result := (points[1].x = points[pcount].X) and
                  (points[1].y = points[pcount].y);
end;

procedure clearmap1;
var i : byte;
begin
 with map1 do with canvas do
  begin
   brush.Color := $f0ffff;
   fillrect(rect(0,0,width,height));
   pen.Color := $fff0f0;
   pen.Width := 1;
   for i := 1 to ((boxwidth-1) div 20) do
    begin
     moveto(i*20,0);
     lineto(i*20,boxheight);
    end;
   for i := 1 to ((boxheight-1) div 20) do
    begin
     moveto(0, i*20);
     lineto(boxwidth, i*20);
    end;
  end;
 update1(rect(0,0,boxwidth,boxheight));
end;

procedure drawline(bm : Tbitmap; p1,p2 : TPoint; c : longInt);
//paint line in bm from p1 to p2, color = c
//update paintrect
begin
 with bm do with canvas do
  begin
   pen.Width := 2;
   pen.color := c;
   moveto(p1.x,p1.y);
   lineto(p2.x,p2.y);
  end;
 paintrect := packrect(p1.X,p1.Y,p2.X,p2.y);
end;

procedure drawpoint(bm : Tbitmap; p : Tpoint);
//draw a point in map1,2 --> box
//update paintrect
begin
 with paintrect do
  begin
   Left := p.x - 2;
   Right := p.x + 3;
   Top := p.y - 2;
   Bottom := p.y + 3;
  end;
 with bm.Canvas do
  begin
   brush.color := $000000;
   pen.color := $000000;
   fillrect(paintrect);
  end;
end;

procedure drawmodlines(bm : Tbitmap; c : LongInt);
//draw lines to/from selpoint , color = c
var closed : boolean;
begin
 if (selpoint > 1) and (selpoint < pcount) then
  begin
   drawline(bm,points[selpoint-1],points[selpoint],c);
   update12(paintrect);
   drawline(bm,points[selpoint],points[selpoint+1],c);
   update12(paintrect);
  end
  else begin
        closed := closecheck;
        if (selpoint = 1) or closed then
         begin
          drawline(bm,points[1],points[2],c);
          update12(paintrect);
         end;
        if (selpoint = pcount) or closed then
         begin
          drawline(bm,points[pcount-1],points[pcount],c);
          update12(paintrect);
         end;
       end;
end;

procedure repaintmap1;
var i : word;
    p1,p2 : Tpoint;
begin
 clearmap1;
 begin
  p1 := points[1];
  drawpoint(map1,p1);
  for i := 2 to pcount do
   begin
    p2 := points[i];
    drawline(map1,p1,p2,$000000);
    drawpoint(map1,p2);
    p1 := p2;
   end;
 end;
end;

procedure undo;
//selpoint <> 0 : remove selpoint
//selpoint = 0  : remove last (=pcount)
//clear, repaint map1
var i : word;
begin
 if pcount = 0 then exit;

 if selpoint = 0 then selpoint := pcount;
 for i := selpoint to pcount-1 do       //shift points down
  begin
   points[i].X := points[i+1].x;
   points[i].Y := points[i+1].y;
   with form1.pointsgrid do
    begin
     cells[0,i-1] := cells[0,i];
     cells[1,i-1] := cells[1,i];
    end;//with..
  end;//for..
 points[pcount].X := 0;
 points[pcount].Y := 0;
 with form1.pointsgrid do
  begin
   cells[0,pcount-1] := '';
   cells[1,pcount-1] := '';
  end;

 dec(pcount);
 if pcount = 1 then
  begin
   pcount := 0;
   with points[1] do
    begin
     x := 0;
     y := 0;
    end; 
   with form1.pointsgrid do
    begin
     cells[0,0] := '';
     cells[1,0] := '';
    end;
  end;
 repaintmap1;
 copymap12;
 copymap2box;
 form1.msgtext.Caption := '';
end;

procedure clearPointsGrid;
//erases pointsGrid
var i : word;
begin
 with form1.pointsgrid do
  begin
   for i := 0 to maxpolypoint-1 do
    begin
     cells[0,i] := ''; cells[1,i] := '';
    end;
   col := 0; row := 0;
  end;//with
end;

procedure showcursor;
//erase old cursor, new at mouseX,mouseY
//mcount = 1
var r : TRect;
    bm : TBitmap;
begin
 r.Left := oldX-4;
 r.Right := oldX+6;
 r.Top := oldY-4;
 r.Bottom := oldY+6;
 if selpoint <> 0 then bm := form1.crsr2.picture.bitmap
  else bm := form1.crsr1.picture.bitmap;

 with form1.PaintBox1.Canvas do
  begin
   copyrect(r,map2.Canvas,r);    //erase old cursor
   draw(mouseX-4,mouseY-4,bm);   //paint new cursor
  end;
end;

procedure onPointCheck;
//check cursor on first or on last point
//set selpoint = 0 if not  or on 1st & last point
var dx,dy : word;
begin
 selpoint := 0;
 if pcount = 0 then exit;

 dx := trunc(abs(mouseX - points[pcount].X));
 dy := trunc(abs(mouseY - points[pcount].Y));
 if (dx < 4) and (dy < 4) then
  begin
   selpoint := pcount;
   if pcount = 1 then exit;
  end;

 dx := trunc(abs(mouseX - points[1].X));
 dy := trunc(abs(mouseY - points[1].Y));
 if (dx < 4) and (dy < 4) then
  if selpoint <> 0 then selpoint := 0
   else selpoint := 1;
end;

procedure onAnyPointCheck;
//selpoint 0:not on point; <> 0:on point
var i : word;
begin
 selpoint := 0;
 for i := 1 to pcount do
  if (abs(mouseX - points[i].x) < 4) and
     (abs(mouseY - points[i].Y) < 4) then
   begin
    selpoint := i;
    break;
   end;
end;

procedure registerpoint(n : word);
//insert (mouseX,mouseY) coordinates at point n
var i : word;
begin
 for i := pcount downto n do
  with points[i+1] do
   begin
    x := points[i].X;
    y := points[i].Y;
   end;
 with points[n] do
  begin
   x := mouseX;
   y := mouseY;
  end;
 inc(pcount);
 with form1.pointsgrid do
  for i := 1 to pcount do
   begin
    cells[0,i-1] := inttostr(points[i].x);
    cells[1,i-1] := inttostr(points[i].y);
   end;
end;

//---main procedures---

procedure drawProc;
//handle mouse events for drawing
//mcount 0 : cursor moving on paintbox
//       1 : after mouse down
//       2 : move after mouse down, drawing
var oldselpoint : word;
    p : TPoint;
begin
 p.x := mouseX; p.y := mouseY;
 case mouseAction of
  maMove :
     case mcount of
       0 : begin
            onPointcheck;
           end;
       1 : begin
            mcount := 2;
           end;
       2 : begin
            copymap12;
            drawline(map2,points[selpoint],p,$000000);
            update12(paintrect);
            copymap2box;
           end;
      end;//case
  maDown :
     case mcount of
       0 : begin
            if pcount = 0 then
             begin
              registerpoint(1);
              selpoint := 1;
              mcount := 1;
              drawpoint(map1,p);
              update1(paintrect);
              copymap12;
              copymap2box;
             end
             else
              if (pcount < maxpolypoint) then
               begin
                if selpoint <> 0 then mcount := 1;
               end
               else form1.msgtext.Caption := 'puntenlijst is vol';
           end;
       1,2 : ;
     end;//case
  maUp   :
    case mcount of
      0 : selpoint := 0;
      1 : begin
           mcount := 0;
           selpoint := 0;
           if pcount = 1 then undo;
          end;
      2 : begin
           mcount := 0;
           oldselpoint := selpoint;
           onPointCheck;
           if selpoint = oldselpoint then undo  //start = end
            else
             begin
              drawline(map1,points[oldselpoint],p,$000000);
              update1(paintrect);
              drawpoint(map1,p);
              update1(paintrect);
              copymap12;
              copymap2box;
              if oldselpoint = pcount then inc(oldselpoint);//append
              registerpoint(oldselpoint);
             end;
           if pcount = 1 then
            begin
             undo;
             selpoint := 0;
            end;
           onPointCheck;
          end;
    end;//case
 end;//case
 showcursor;
end;

procedure modifyProc;
//handle mouse events for modification of drawing
//mcount 0 : cursor moving on paintbox
//       1 : after mouse down
//       2 : move after mouse down, modifying
var closed : boolean;
begin
 case mouseAction of
  maMove :
     case mcount of
       0 : begin
            onAnyPointCheck;
           end;
       1 : begin
            mcount := 2;
           end;
       2 : begin
            copymap12;
            closed := closecheck;
            points[selpoint].X := mouseX;
            points[selpoint].Y := mouseY;
            with form1.pointsgrid do
             begin
              cells[0,selpoint-1] := inttostr(mouseX);
              cells[1,selpoint-1] := inttostr(mouseY);
             end;
            if (selpoint = 1) and closed then
             begin
              points[pcount].X := mouseX;
              points[pcount].Y := mouseY;
              with form1.pointsgrid do
               begin
                cells[0,pcount-1] := cells[0,0];
                cells[1,pcount-1] := cells[1,0];
               end;
             end;//if..
            with form1 do
             if autoprocbox.checked then
              begin
               repaintmap1;
               areabtnclick(form1.paintbox1);
              end
              else begin
                    drawmodlines(map2,$000000);
                    copymap2box;
                   end;
           end;
      end;//case
  maDown :
     case mcount of
       0 : begin
            if selpoint <> 0 then
             begin
              mcount := 1;
              drawmodlines(map1,$a0a0a0);
              update1(paintrect);
              copymap12;
              copymap2box;
             end;
           end;
       1,2 : ;
     end;//case
  maUp   :
    case mcount of
      0,1 : begin
             selpoint := 0;
             mcount := 0;
            end;
        2 : begin
             if form1.autoprocbox.checked = false then repaintmap1;
             copymap12;
             copymap2box;
             mcount := 0;
             selpoint := 0;
            end;
    end;//case
 end;//case
 showcursor;
end;

//----mouse events----

procedure TForm1.PaintBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
 if (x < 0) or (y < 0) or (x >= boxwidth) or (y >= boxheight) then exit;

 if (mainbutton = mbDraw) or (not (ssShift in shift)) then //draw only in
  if (abs(x-oldX) >= 10) or (abs(y-oldY) >= 10) then       //coarse mode
   begin
    x := ((x+5) div 10) * 10;
    y := ((y+5) div 10) * 10;
   end
    else begin
          x := oldX;
          y := oldY;
         end;

  xposlabel.caption := inttostr(x);
  yposlabel.Caption := inttostr(y);
  mouseX := x;
  mouseY := y;
  mouseAction := maMove;
  case mainbutton of
   mbDraw   : drawProc;
   mbModify : modifyProc;
  end;//case
  oldX := x;
  oldY := y;
end;

procedure TForm1.PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 mouseAction := maDown;
 case mainbutton of
  mbDraw   : drawproc;
  mbModify : modifyProc;
 end;//case
end;

procedure TForm1.PaintBox1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 mouseAction := maUp;
 case mainbutton of
  mbDraw   : drawproc;
  mbModify : modifyProc;
 end;//case
end;

//---------create , destroy -------------

procedure TForm1.FormCreate(Sender: TObject);
var i : byte;
begin
 with paintbox1 do
  begin
   width := boxwidth;
   height := boxheight;
  end;
 pcount := 0;
 pointsgrid.RowCount := maxpolypoint;
 map1 := Tbitmap.Create;
 with map1 do
  begin
   pixelformat := pf32bit;
   width := boxwidth;
   height := boxheight;
   canvas.brush.Color := $fffffe;
  end;
 map2 := Tbitmap.Create;
 with map2 do
  begin
   pixelformat := pf32bit;
   width := boxwidth;
   height := boxheight;
  end;
 map1full := false;
 map2full := false;
 clearmap1;
 copymap12;
 msgtext.Caption := 'welkom bij de geo-data creator';
 selpoint := 0;
 mainbutton := mbDraw;
 decimalseparator := '.';
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
 map1.Free;
 map2.Free;
 map1 := nil;
 map2 := nil;
end;

//---- btn clicks ----------

procedure TForm1.areaBtnClick(Sender: TObject);
const fst ='###0.0##';
var i : word;
    area : double;
begin
 setCanvas(map1.canvas);
 setpencolor(pencolor);
 setBGcolor(fillcolor);
 setBGmode(fillcheckbox.Checked);
 setShowTriangles(trianglecheckbox.checked);
 clearmap1;
 area := polyArea(@points[1],pcount); //redraws map1 if OK
 if polyresultcode <> 0 then
  begin
   msgtext.caption := getPolyResultmessage;
   repaintbtnClick(repaintBtn);//restore if error
  end
  else
  begin
   msgtext.Caption := 'area = ' + formatfloat(fst,Area) +
                          '  (' + formatfloat('#####0',polyTime) + ' microsecs)';
   copymap12;
   copymap2box;                       
  end;
end;

procedure TForm1.undoBtnClick(Sender: TObject);
begin
 if mainbutton = mbDraw then undo;
end;

procedure TForm1.clearbtnClick(Sender: TObject);
//clear button clicked
var i : word;
begin
 msgtext.Caption := '';
 clearpointsGrid;
 for i := 1 to maxpolypoint do
  with points[i] do
   begin
    x := 0;
    y := 0;
   end;
 pcount := 0;
 clearmap1;
 copymap12;
 copymap2box;   
end;

procedure TForm1.drawbtnClick(Sender: TObject);
begin
 mainbutton := mbDraw;
 msgtext.caption := 'draw polygon';
end;

procedure TForm1.modifyBtnClick(Sender: TObject);
begin
 mainbutton := mbModify;
 msgtext.caption := 'modify polygon';
end;

procedure TForm1.repaintBtnClick(Sender: TObject);
//remove triangles info, background
begin
 repaintmap1;
 copymap12;
 copymap2box;
end;

//---paints----

procedure TForm1.PaintBox1Paint(Sender: TObject);
var r : Trect;
begin
 r := rect(0,0,boxwidth,boxheight);
 paintbox1.canvas.copyrect(r,map2.canvas,r);
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
 pbedge(paintbox1,2);
end;

//----keyboard------

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
//allow only 0..9, . , backspace
begin
 if not (key in ['0'..'9',#8,'.']) then key := #0;

 case mainbutton of
  mbDraw    : if key = #8 then
               begin
                undo;
                key := #0;
               end;
  mbModify  : key := #0;
 end;//case
end;

procedure TForm1.xleftKeyPress(Sender: TObject; var Key: Char);
//allow 1 decimal point only
begin
 with sender as Tedit do
  if (key = '.') and (pos('.',text) > 0) then key := #0;
end;

procedure TForm1.pointsgridKeyPress(Sender: TObject; var Key: Char);
begin
 with sender as TstringGrid do
  if (key = '.') and (pos('.', cells[col,row]) > 0) then key := #0;
end;

//---general support---

procedure pbedge(pb : Tpaintbox; w : byte);
//draw egde width w around paintbox pb
const c1 = $000000;   //top, left color
      c2 = $a0a0a0;   //bottom,right color
var x1,y1,x2,y2 : word;
    frm : Tcustomform;
    i : byte;
begin
 frm := getparentform(pb);
 with pb do
  begin
   x1 := left - w;
   y1 := top -w;
   x2 := left + width + w - 1;
   y2 := top + height + w - 1;
  end;
 with frm.canvas do
  begin
   pen.Width := 1;
   for i := 0 to w-1 do
    begin
     pen.Color := c1;
     moveto(x2-i,y1+i);
     lineto(x1+i,y1+i);
     lineto(x1+i,y2-i);
     pen.Color := c2;
     lineto(x2-i,y2-i);
     lineto(x2-i,y1+i);
    end;
  end;//with
end;

end.
