unit clock_unit;

{
   CPU microseconds clock

   calls:

     procedure setCPUclock;//call once to set proper CPU clock rate
     procedure getCPUticks(var count: Int64);//set count to CPU clock cycles
     function getproctime(t) : double;

   to measure time:

   - record start tick count t1
   - process....
   - record end tick count t2
   - process time = proctime(t2 - t1)
}

interface

procedure getCPUticks(var count: Int64);
function proctime(t : Int64) : longInt;

implementation

uses windows;

var clockOK : boolean = false;
    clockRate : word = 2400;

procedure getCPUticks(var count: Int64);
//store 64 bits CPU clock in variable count
begin
 asm
  mov ECX,count;
  RDTSC;          //lower 32 bits --> EAX, upper 32 bits ---> EDX
                  //RDTSC = DB $0F,$31
  mov [ECX],EAX;
  add ECX,4;
  mov [ECX],EDX;
 end;
end;

procedure setCPUclock;
//set variable CPUclock
//call this procedure once before measuring any process time
var t1,t2 : cardinal;         //system clock ticks
    cput1,cput2 : Int64;      //CPU clock ticks
begin
 if clockOK then exit;

 t1 := getTickCount;          //get milliseconds clock
 while getTickCount = t1 do;  //sync with start of 1 millisec interval
 getCPUticks(cput1);          //get CPU clock count
 t1 := gettickcount;
 repeat
  getCPUticks(cput2);         //get CPU clock count
  t2 := gettickcount;
 until t2-t1 >= 500;
 clockrate := trunc((cput2-cput1)/((t2-t1)*1e3));  //set CPU clock in microsecs
 clockOK := true;
end;

function proctime(t : Int64) : longInt;
//convert process ticks t to microsecs
begin
 if clockOK = false then setCPUclock;
 result := trunc(t/clockrate);
end;

end.
