unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons,shellApi,jpeg;

type
  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    loadBtn: TButton;
    OpenDialog1: TOpenDialog;
    Label2: TLabel;
    pixelslabel: TStaticText;
    Label4: TLabel;
    colorcountlabel: TStaticText;
    restoreBtn: TButton;
    Label10: TLabel;
    Label11: TLabel;
    widthlabel: TStaticText;
    heightlabel: TStaticText;
    Label15: TLabel;
    compressionlabel: TStaticText;
    Label3: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    leftlabel: TStaticText;
    toplabel: TStaticText;
    newlabel: TStaticText;
    compresBtn: TButton;
    pixcountlabel: TStaticText;
    greyBtn: TButton;
    Label12: TLabel;
    stacklabel: TStaticText;
    decompBtn: TButton;
    msglabel: TLabel;
    bitBtn: TButton;
    SaveDialog1: TSaveDialog;
    saveBtn: TButton;
    label8: TLabel;
    Image1: TImage;
    Label9: TLabel;
    expleftlabel: TStaticText;
    Label13: TLabel;
    exptoplabel: TStaticText;
    Label14: TLabel;
    deltalabel: TStaticText;
    vbar: TScrollBar;
    hbar: TScrollBar;
    Label1: TLabel;
    Label5: TLabel;
    procedure loadBtnClick(Sender: TObject);
    procedure restoreBtnClick(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure compresBtnClick(Sender: TObject);
    procedure greyBtnClick(Sender: TObject);
    procedure decompBtnClick(Sender: TObject);
    procedure bitBtnClick(Sender: TObject);
    procedure saveBtnClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure vbarChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses compressunit;

const msg1 = 'no image loaded';
      msg2 = 'image not compressed';
      msg3 = 'no action';
      msg4 = 'wrong file type';
      msg5 = 'wrong format';
      msg6 = 'image compressed';
      msg7 = 'verified : OK';
      msg8 = 'miscompare';
      msg9 = 'image reloaded';
      msg10 = 'image loaded';
      msg11 = 'grey 4 bit colors';
      msg12 = 'file saved';
      msg13 = 'file write error';
      msg14 = 'file read error';
      msg15 = 'unknown file type';
      msg16 = 'image too large';
      msg17 = 'working...please wait...';
      pic   = 'pic';
      spic  = 'spic';
//
      hormaxsize = 4000;//max size of bitmaps
      vermaxsize = 3000;//..

type PDW = ^DWORD;
     Tprogramstate = (psEmpty,psLoaded,psCompressed);

var bmbackup : TBitmap;
    dmap : Tbitmap;
    bm : TBitmap;
    p0 : dword;
    ps : dword;
    pixelcount : dword;
    programstate : Tprogramstate = psEmpty;
    flGrey : boolean;

procedure adjustscrollbars;
//after loading new image
begin
 with form1 do
  begin
   if bm.Width > 960 then hbar.Max := bm.Width-960
    else hbar.Max := 0;
   if bm.Height > 720 then vbar.Max := bm.Height - 720
    else vbar.Max := 0;
   hbar.Position := 0;
   vbar.position := 0; 
  end;
end;

procedure clearpaintbox;
begin
 with form1.PaintBox1 do with canvas do
  begin
   brush.color := color;
   brush.style := bsSolid;
   fillrect(rect(0,0,width,height));
  end;
end;

procedure bm2paintbox;
var rs,rd : Trect;
    w,h : word;
begin
 with form1 do
  begin
   if bm.Width > 960 then w := 960 else w := bm.Width;
   if bm.Height > 720 then h := 720 else h := bm.Height;
   rd := rect(0,0,w,h);
   rs := rect(hbar.Position,vbar.position,hbar.position+h,
              vbar.Position+h);
   paintbox1.canvas.copyrect(rd,bm.Canvas,rs);
  end;
end;

procedure setpixelcount;
begin
 pixelcount := bm.Width * bm.Height;
 form1.pixelslabel.caption := inttostr(pixelcount);
end;

procedure showcolorcount;
begin
 form1.colorcountlabel.Caption := inttostr(colorcount);
end; 

procedure clearStatistics;
const s = '';
begin
 with form1 do
  begin
   newlabel.Caption := s;
   deltalabel.Caption := s;
   stacklabel.caption := s;
   leftlabel.Caption := s;
   expleftlabel.Caption := s;
   toplabel.Caption := s;
   exptoplabel.Caption := s;
   pixcountlabel.caption := s;
   compressionlabel.caption := s;
  end; 
end;

procedure resetBM;
//setup map, clear data
begin
 setMap(bm);
 clearstatistics;
 showcolorcount;
 form1.paintbox1.invalidate;
end;

procedure showstatistics;
begin
 with form1 do
  begin
   newlabel.Caption := inttostr(statistics[stNew]);
   deltalabel.Caption := inttostr(statistics[stDelta]);
   stacklabel.Caption := inttostr(statistics[stStack]);
   leftlabel.Caption := inttostr(statistics[stLeft]);
   expleftlabel.Caption := inttostr(statistics[stExpLeft]);
   toplabel.Caption := inttostr(statistics[stTop]);
   exptoplabel.Caption := inttostr(statistics[stExpTop]);
   pixcountlabel.Caption := inttostr(dircount);
   compressionlabel.Caption :=
     formatfloat('0.00',dircount*400/(3*pixelcount))+'%';
  end;
end;

function comparemaps : boolean;
//compare bm - dmap
var x,y : word;
    pd0,pds,pld,pls,pdest,psrc : dword;
begin
 result := true;
 pd0 := dword(dmap.scanline[0]);
 pds := pd0 - dword(dmap.scanline[1]);
 y := 0;
 repeat
  x := 0;
  pld := pd0- y*pds;
  pls := p0 - y*ps;
  repeat
   pdest := pld + (x shl 2);
   psrc := pls + (x shl 2);
   if PDW(psrc)^ = PDW(pdest)^ then inc(x) else result := false;
  until (result = false) or (x = bm.Width);
  inc(y);
 until (result = false) or (y = bm.height);
end; 

procedure TForm1.restoreBtnClick(Sender: TObject);
//restore
begin
 if programstate = psEmpty then
  begin
   msglabel.Caption := msg1;
   exit;
  end;

 bm.Canvas.Draw(0,0,bmbackup);
 clearAll;
 setmap(bm);
 colorfix12;
 setpixelcount;
 showcolorcount;
 clearstatistics;
 paintbox1.Invalidate;
 programstate := psLoaded;
 flgrey := false;
 msglabel.Caption := msg9;
end;

procedure TForm1.loadBtnClick(Sender: TObject);
//load picture
var s : string;
    f : file of dword;
    data : dword;
    i,err : byte;
    OK : boolean;
    count : dword;
    jpegImage : TJpegImage;
begin
 OK := true;
 count := 0;
 with opendialog1 do
  begin
   filter := 'bmp,jpeg,pic|*.bmp;*.jpg;*.pic';
  if execute then
   begin
    programstate := psEmpty;
    s := lowercase(extractFileExt(filename));
    if s = '.jpg' then
     begin
      jpegImage := TJpegImage.Create;
      JpegImage.LoadFromFile(filename);
      bm.Width := jpegimage.Width;
      bm.Height := jpegimage.Height;
      bm.Canvas.Draw(0,0,jpegimage);
      programstate := psLoaded;       //loaded image
      jpegimage.Free;
     end;                             //end jpg read
    if s = '.bmp' then
     begin
      bm.loadfromfile(filename);
      bm.PixelFormat := pf32bit;
      programstate := psLoaded;      //loaded image
     end;                            //end bmp read
    if programstate = psLoaded then
     begin
      OK := (bm.Width <= hormaxsize) and (bm.Height <= vermaxsize);
      if OK then
       begin
        p0 := dword(bm.ScanLine[0]);      //p0 in unit1
        ps := p0 - dword(bm.scanline[1]); //ps ........
        setmap(bm);                       //sets p0,ps in compressunit
        colorfix12;
        flGrey := false;
       end
      else
       begin
        programstate := psEmpty;
        bm.Width := 960;
        bm.Height := 720;
        msglabel.Caption := msg16;   //error message
       end; // not OK
      adjustscrollbars;
     end;                                  //end file loaded
    if s = '.pic' then                    //pic file
     begin
      clearAll;
      msglabel.Caption := msg17;          //working...
      application.ProcessMessages;
{$I+}
      try
       try
        assignfile(f,filename);
        reset(f);
        while not eof(f) do
         begin
          read(f,data);
          count := storeDirector(data);   //inc ptr
         end;
       except
        OK := false;
       end;
      finally
       closefile(f);
      end;
{$I-}

      if OK = false then
       begin
        msglabel.Caption := msg14;    //file read error
        exit;
       end;

      dircount := count;
      data := getDirector(0);
      s := '';
      for i := 0 to 3 do s := s + chr((data shr (8*i)) and $ff);
      if s <> spic then    //check file type
       begin
        msglabel.Caption := msg15; //unknown file type
        exit;
       end;
      data := getdirector(1);
      flGrey := (data shr 24) and $f = 4;
      bm.Width := data and $fff;
      bm.Height := (data shr 12) and $fff;
      p0 := dword(bm.ScanLine[0]);      //p0 in unit1
      ps := p0 - dword(bm.scanline[1]); //ps..........
      setmap(bm);
      resetDir;
      decompress(err);
      case err of
       1 : msglabel.caption := msg4;
       2 : msglabel.caption := msg5;
      end;
      if err <> 0 then exit;
      programstate := psCompressed;
      scancolors;
     end;                               //pic end
//
    if programstate <> psEmpty then
     begin
      bmbackup.Width := bm.Width;
      bmbackup.Height := bm.Height;
      bmbackup.Canvas.Draw(0,0,bm);
      widthlabel.Caption := inttostr(bm.Width);
      heightlabel.Caption := inttostr(bm.Height);
      setpixelcount;
      clearstatistics;
      msglabel.Caption := msg10;
      s := extractfilename(filename);
      delete(s,pos('.',s),4);          //remove .bmp
      caption := spic + ':' + s;
      showcolorcount;
      clearpaintbox;
      bm2paintbox;
     end;                             //end loaded file
   end;//execute
  end;//with opendialog1
end;

procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
 bm2paintbox;
end;

procedure TForm1.compresBtnClick(Sender: TObject);
//compress bitmap
begin
 if programstate = psEmpty then
  begin
   msglabel.caption := msg1;
   exit;
  end;

 clearAll;
 setmap(bm);
 if flGrey then compressGrey else compress12;
 programstate := psCompressed;
 showstatistics;
 msglabel.Caption := msg6;
end;

procedure TForm1.greyBtnClick(Sender: TObject);
begin
 if programstate = psEmpty then
  begin
   msglabel.caption := msg1;
   exit;
  end;

 setmap(bm);
 greyscale;
 showcolorcount;
 paintbox1.invalidate;
 flGrey := true;
 msglabel.Caption := msg11;
end;

procedure TForm1.decompBtnClick(Sender: TObject);
//decompress
var ec : byte;
begin
 if programstate = psEmpty then
  begin
   msglabel.caption := msg1;
   exit;
  end;

 if programstate = psloaded then
  begin
   msglabel.caption := msg2;
   exit;
  end;

 setmap(dmap);
 ResetDir;
 decompress(ec);
 case ec of
  1 : msglabel.caption := msg4;
  2 : msglabel.caption := msg5;
 end;
 if ec = 0 then
  if comparemaps then msglabel.Caption := msg7
   else msglabel.Caption := msg8;
 paintbox1.Canvas.Draw(0,0,dmap);//show dmap
end;

procedure TForm1.bitBtnClick(Sender: TObject);
//show director bits in paintbox
var i,column,row : byte;
    j,dir : dword;
    c : char;
    x,y : word;
begin
 if programstate <> psCompressed then
  begin
   msglabel.Caption := msg2;
   exit;
  end;

 with paintbox1 do with Canvas do
  begin
   brush.Color := color;
   brush.style := bssolid;
   fillrect(rect(0,0,width,height));
   font.Name := 'courier new';
   font.Height := 16;
   for j := 0 to 59 do
    begin
     column := j div 30;
     row := j mod 30;
     y := row*18;
     x := column*400;
     dir := getdirector(j);
     for i := 31 downto 0 do
      begin
       if (i and 4) = 0 then brush.Color := $ffff
        else brush.Color := $ffffff;
       c := chr(ord('0')+((dir shr i) and 1));
       textout(x+(31-i)*10,y,c);
      end;
    end;
  end;
end;

procedure TForm1.saveBtnClick(Sender: TObject);
//save a compressed file as *.pic
var f : file of dword;
    i,dir : dword;
    ok : boolean;
    s,fname : string;
begin
 OK := true;
 with savedialog1 do
  begin
   s := '';
   if Execute then
    begin
     case filterindex of
      1 : s := '.pic';
      2 : s := '.bmp';
     end;
     i := pos('.',filename);
     if i > 0 then begin
                    fname := filename;
                    delete(fname,i,4);  //remove old extension
                    filename := fname;
                   end;
     filename := filename + s;
     if (s = '.bmp') then
      if programstate <> psEmpty then bm.SaveToFile(filename)
       else begin
             msglabel.Caption := msg1;    //no file loaded
             exit;
            end;

     if s = '.pic' then
      begin
       if programstate <> psCompressed then
        begin
         msglabel.Caption := msg2;
         exit;
        end;
        
       msglabel.caption := msg17;
       application.ProcessMessages;
{$I+}
       try
        try
         assignfile(f,filename);
         rewrite(f);
         for i := 0 to dircount-1 do
          begin
           dir := getDirector(i);
           write(f,dir);
          end;
        except
         OK := false;
        end;
       finally
        closefile(f);
       end; 
      end;             //if pic
    end;               //execute  
  end;                 //with savedialog
{$I-}

 if OK then msglabel.Caption := msg12
  else msglabel.Caption := msg13;
end;

procedure paintedge(cp : TControl);
var x1,y1,x2,y2 : word;
begin
 with cp do
  begin
   x1 := left-1;
   y1 := top-1;
   x2 := left + width;
   y2 := top + height;
  end;
 with form1.canvas do
  begin
   pen.Color := $0;
   moveto(x1,y1);
   lineto(x1,y2);
   lineto(x2,y2);
   lineto(x2,y1);
   lineto(x1,y1);
  end;
end;

procedure TForm1.FormPaint(Sender: TObject);
//pait edge around paintbox
begin
 paintedge(paintbox1);
 paintedge(msglabel);
 msglabel.color := $e0ffff;
end;

procedure TForm1.Image1Click(Sender: TObject);
begin
 ShellExecute(0,'open','http://www.davdata.nl', nil, nil, SW_SHOWNORMAL);
end;

procedure TForm1.vbarChange(Sender: TObject);
begin
 bm2paintbox;
end;

initialization

 bm := Tbitmap.Create;
 with bm do
  begin
   width := 960;
   height := 720;
   pixelformat := pf32bit;
  end;
 bmbackup := TBitmap.Create;
 with bmbackup do
  begin
   width := 960;
   height := 720;
   pixelformat := pf32bit;
  end;
 dmap := TBitmap.create;
 with dmap do
  begin
   pixelformat := pf32bit;
   width := 10;
   height := 10;
  end;

finalization

  bm.Free;
  bmbackup.Free;
  dmap.free;

end.
